<?= $this-> include('templates/header_data');?>
<!-- Start: header -->
<header id="nsofts_header">
    <a href="javascript:void(0)" id="nsofts_hamburger_top">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 18 18" width="18" height="18" class="nsofts-hamburger">
            <line x1="0" y1="50%" x2="100%" y2="50%" class="nsofts-hamburger__bar-1" />
            <line x1="0" y1="50%" x2="100%" y2="50%" class="nsofts-hamburger__bar-2" />
            <line x1="0" y1="50%" x2="100%" y2="50%" class="nsofts-hamburger__bar-3" />
        </svg>
    </a>
    <a href="javascript:void(0)" id="nsofts_brand" class="text-truncate"><?= esc($settings['app_name']) ?></a>

    <!-- Header options -->
    <ul class="nsofts-header-nav ms-auto">
        <li class="nsofts-header-nav__item">
            <a href="javascript:void(0)" id="nsofts_theme_toggler" class="nsofts-header-nav__link">
                <i class="ri-moon-fill nsofts-theme-dark"></i>
                <i class="ri-sun-fill nsofts-theme-light"></i>
            </a>
        </li>
        <li class="nsofts-header-nav__item dropdown">
            <a href="javascript:void(0)" class="nsofts-header-nav__link" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                <i class="ri-user-6-fill"></i>
            </a>
            <div class="dropdown-menu mt-3">
                <div class="px-3 py-2">
                    <div class="nsofts-avatar">
                        <div class="nsofts-avatar__image">
                            <?php
                            $image = session()->get('userdata')->image ?? '';
                            $imagePath = $image ? base_url('images/' . esc($image)) : base_url('assets/images/user_photo.png');
                            ?>
                            <img src="<?= $imagePath ?>" alt="">
                        </div>
                        <div class="ps-2">
                            <span class="d-block fw-semibold"><?= session()->get('userdata')->username ?? '' ?></span>
                            <?php 
                            $adminType = session()->get('userdata')->admin_type ?? null;
                            if ($adminType !== null): 
                            ?>
                                <?php if($adminType == 1){?>
                                    <span class="d-block">ADMIN</span>
                                <?php } else if($adminType == 0){?>
                                    <span class="d-block">EDITOR</span>
                                <?php } else if($adminType == 2){?>
                                    <span class="d-block">RESELLER</span>
                                <?php } else if($adminType == 3){?>
                                    <span class="d-block">SUPER ADMIN</span>
                                <?php } else { ?>
                                    <span class="d-block"><?= $adminType ?></span>
                                <?php } ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="dropdown-divider"></div>
                <a class="dropdown-item dropdown-item--group" href="<?= base_url('ns-admin/profile') ?>">
                    <i class="ri-user-6-fill"></i>
                    <span>My Profile</span>
                </a>
                <a class="dropdown-item dropdown-item--group" href="<?= base_url('ns-admin/settings-panel') ?>">
                    <i class="ri-settings-3-fill"></i>
                    <span>Settings</span>
                </a>
                <div class="dropdown-divider"></div>
                <a class="dropdown-item dropdown-item--group" href="<?= base_url('ns-admin/logout') ?>">
                    <i class="ri-shut-down-line"></i>
                    <span>Logout</span>
                </a>
            </div>
        </li>
    </ul>
</header>
<!-- End: header -->

<!-- Start: sidebar -->
<aside id="nsofts_sidebar">
    <nav class="nsofts-sidebar-nav" data-scroll="true">
        <ul>
            
            <li class="nsofts-sidebar-nav__item">
                <a href="javascript:void(0)" id="nsofts_hamburger" class="nsofts-sidebar-menu">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 18 18" width="18" height="18" class="nsofts-hamburger">
                        <line x1="0" y1="50%" x2="100%" y2="50%" class="nsofts-hamburger__bar-1" />
                        <line x1="0" y1="50%" x2="100%" y2="50%" class="nsofts-hamburger__bar-2" />
                        <line x1="0" y1="50%" x2="100%" y2="50%" class="nsofts-hamburger__bar-3" />
                    </svg>
                </a>
            </li>
            
            <li class="nsofts-sidebar-nav__item">
                <a href="<?= base_url('ns-admin/dashboard') ?>" class="nsofts-sidebar-nav__link <?php if ($currentFile == "dashboard") { ?>active<?php } ?>">
                    <i class="ri-home-4-line nsofts-sidebar-nav__icon"></i>
                    <span class="nsofts-sidebar-nav__text">Dashboard</span>
                </a>
            </li>
            
            <li class="nsofts-sidebar-nav__item">
                <a href="<?= base_url('ns-admin/manage-category') ?>" class="nsofts-sidebar-nav__link <?php if ($currentFile == "categories") { ?>active<?php } ?>">
                    <i class="ri-folder-3-line nsofts-sidebar-nav__icon"></i>
                    <span class="nsofts-sidebar-nav__text">Category</span>
                </a>
            </li>
            
            <li class="nsofts-sidebar-nav__item">
                <a href="<?= base_url('ns-admin/manage-countries') ?>" class="nsofts-sidebar-nav__link <?php if ($currentFile == "countries") { ?>active<?php } ?>">
                    <i class="ri-global-line nsofts-sidebar-nav__icon"></i>
                    <span class="nsofts-sidebar-nav__text">Countries</span>
                </a>
            </li>
            
            <li class="nsofts-sidebar-nav__item">
                <a href="<?= base_url('ns-admin/manage-radios') ?>" class="nsofts-sidebar-nav__link <?php if ($currentFile == "radios") { ?>active<?php } ?>">
                    <i class="ri-radio-2-line nsofts-sidebar-nav__icon"></i>
                    <span class="nsofts-sidebar-nav__text">Radios</span>
                </a>
            </li>
            
            <li class="nsofts-sidebar-nav__item nsofts-has-menu">
                <a href="javascript:void(0)" class="nsofts-sidebar-nav__link <?php if ($currentFile == "podcast" or $currentFile == "episode") { ?>open active<?php } ?>">
                    <i class="ri-disc-line nsofts-sidebar-nav__icon"></i>
                    <span class="nsofts-sidebar-nav__text">Podcast</span>
                </a>
                <ul class="nsofts-submenu <?php if ($currentFile == "podcast" or $currentFile == "episode") { ?>show<?php } ?>">
                    <li>
                        <a href="<?= base_url('ns-admin/manage-podcast') ?>" class="nsofts-submenu__link <?php if ($currentFile == "podcast") { ?>active<?php } ?>">Podcast</a>
                    </li>
                    <li>
                        <a href="<?= base_url('ns-admin/manage-episode') ?>" class="nsofts-submenu__link <?php if ($currentFile == "episode") { ?>active<?php } ?>">Episode</a>
                    </li>
                </ul>
            </li>
            
            <li class="nsofts-sidebar-nav__item nsofts-has-menu">
                <a href="javascript:void(0)" class="nsofts-sidebar-nav__link <?php if ($currentFile == "banner" or $currentFile == "sections") { ?>open active<?php } ?>">
                    <i class="ri-list-check-2 nsofts-sidebar-nav__icon"></i>
                    <span class="nsofts-sidebar-nav__text">Home</span>
                </a>
                <ul class="nsofts-submenu <?php if ($currentFile == "banner" or $currentFile == "sections") { ?>show<?php } ?>">
                    <li>
                        <a href="<?= base_url('ns-admin/manage-banner') ?>" class="nsofts-submenu__link <?php if ($currentFile == "banner") { ?>active<?php } ?>">Banner</a>
                    </li>
                    <li>
                        <a href="<?= base_url('ns-admin/manage-sections') ?>" class="nsofts-submenu__link <?php if ($currentFile == "sections") { ?>active<?php } ?>">Sections</a>
                    </li>
                </ul>
            </li>
            
            <?php if($adminType !== null && $adminType != 2){?>
            
                <li class="nsofts-sidebar-nav__item nsofts-has-menu">
                    <a href="javascript:void(0)" class="nsofts-sidebar-nav__link <?php if ($currentFile == "notification_onesignal" or $currentFile == "notification_user") { ?>open active<?php } ?>">
                        <i class="ri-notification-2-line nsofts-sidebar-nav__icon"></i>
                        <span class="nsofts-sidebar-nav__text">Notification</span>
                    </a>
                    <ul class="nsofts-submenu <?php if ($currentFile == "notification_onesignal" or $currentFile == "notification") { ?>show<?php } ?>">
                        <li>
                            <a href="<?= base_url('ns-admin/notification-onesignal') ?>" class="nsofts-submenu__link <?php if ($currentFile == "notification_onesignal") { ?>active<?php } ?>">Push Notification</a>
                        </li>
                        <li>
                            <a href="<?= base_url('ns-admin/notification-user') ?>" class="nsofts-submenu__link <?php if ($currentFile == "notification_user") { ?>active<?php } ?>">Notify a User</a>
                        </li>
                    </ul>
                </li>
                
            <?php } ?>
            
            <li class="nsofts-sidebar-nav__item">
                <a href="<?= base_url('ns-admin/manage-suggestion') ?>" class="nsofts-sidebar-nav__link <?php if ($currentFile == "suggestion") { ?>active<?php } ?>">
                    <i class="ri-dossier-line nsofts-sidebar-nav__icon"></i>
                    <span class="nsofts-sidebar-nav__text">Suggestion</span>
                </a>
            </li>
            
              
            
                <li class="nsofts-sidebar-nav__item">
                    <a href="<?= base_url('ns-admin/manage-report') ?>" class="nsofts-sidebar-nav__link <?php if ($currentFile == "manage_report") { ?>active<?php } ?>">
                        <i class="ri-feedback-line nsofts-sidebar-nav__icon"></i>
                        <span class="nsofts-sidebar-nav__text">Reports</span>
                    </a>
                </li>
                
                <li class="nsofts-sidebar-nav__item">
                    <a href="<?= base_url('ns-admin/manage-subscription') ?>" class="nsofts-sidebar-nav__link <?php if ($currentFile == "subscription") { ?>active<?php } ?>">
                        <i class="ri-exchange-dollar-fill nsofts-sidebar-nav__icon"></i>
                        <span class="nsofts-sidebar-nav__text">Subscription</span>
                    </a>
                </li>
                
                <li class="nsofts-sidebar-nav__item">
                    <a href="<?= base_url('ns-admin/manage-data-deletion') ?>" class="nsofts-sidebar-nav__link <?php if ($currentFile == "data_deletion") { ?>active<?php } ?>">
                        <i class="ri-alarm-warning-line nsofts-sidebar-nav__icon"></i>
                        <span class="nsofts-sidebar-nav__text">Store Policy</span>
                    </a>
                </li>
                
                <li class="nsofts-sidebar-nav__item">
                    <a href="<?= base_url('ns-admin/manage-users') ?>" class="nsofts-sidebar-nav__link <?php if ($currentFile == "users") { ?>active<?php } ?>">
                        <i class="ri-folder-user-line nsofts-sidebar-nav__icon"></i>
                        <span class="nsofts-sidebar-nav__text">Users</span>
                    </a>
                </li>
                
                <li class="nsofts-sidebar-nav__item">
                    <a href="<?= base_url('ns-admin/manage-admin') ?>" class="nsofts-sidebar-nav__link <?php if ($currentFile == "manage_admin") { ?>active<?php } ?>">
                        <i class="ri-admin-line nsofts-sidebar-nav__icon"></i>
                        <span class="nsofts-sidebar-nav__text">Admin</span>
                    </a>
                </li>
                
                <li class="nsofts-sidebar-nav__item nsofts-has-menu">
                    <a href="javascript:void(0)" class="nsofts-sidebar-nav__link <?php if ($currentFile == "settings_panel" or $currentFile == "settings_app" 
                    or $currentFile == "settings_web" or $currentFile == "create_sidebar" or $currentFile == "settings_ads") { ?>open active<?php } ?>">
                        <i class="ri-settings-line nsofts-sidebar-nav__icon"></i>
                        <span class="nsofts-sidebar-nav__text">Settings</span>
                    </a>
                    <ul class="nsofts-submenu <?php if ($currentFile == "settings_panel" or $currentFile == "settings_app" 
                    or $currentFile == "settings_web" or $currentFile == "create_sidebar" or $currentFile == "settings_ads") { ?>show<?php } ?>">
                        <li><a href="<?= base_url('ns-admin/settings-panel') ?>" class="nsofts-submenu__link <?php if ($currentFile == "settings_panel") { ?>active<?php } ?>">Panel Settings</a></li>
                        <li><a href="<?= base_url('ns-admin/settings-app') ?>" class="nsofts-submenu__link <?php if ($currentFile == "settings_app") { ?>active<?php } ?>">App Settings</a></li>
                        <li><a href="<?= base_url('ns-admin/settings-web') ?>" class="nsofts-submenu__link <?php if ($currentFile == "settings_web" or $currentFile == "create_sidebar") { ?>active<?php } ?>">Web Settings</a></li>
                        <li><a href="<?= base_url('ns-admin/settings-ads') ?>" class="nsofts-submenu__link <?php if ($currentFile == "settings_ads") { ?>active<?php } ?>">Advertisement</a></li>
                    </ul>
                </li>
                
                <li class="nsofts-sidebar-nav__item">
                    <a href="<?= base_url('ns-admin/verification') ?>" class="nsofts-sidebar-nav__link <?php if ($currentFile == "verification") { ?>active<?php } ?>">
                        <i class="ri-shield-check-line nsofts-sidebar-nav__icon"></i>
                        <span class="nsofts-sidebar-nav__text">Verification</span>
                    </a>
                </li>
            

            
            <li class="nsofts-sidebar-nav__item">
                <a href="<?= base_url('ns-admin/urls') ?>" class="nsofts-sidebar-nav__link <?php if ($currentFile == "urls") { ?>active<?php } ?>">
                    <i class="ri-links-line nsofts-sidebar-nav__icon"></i>
                    <span class="nsofts-sidebar-nav__text">URLs</span>
                </a>
            </li>
        </ul>
    </nav>
</aside>
<!-- End: sidebar -->